''Playing Cards Demo for VGA     *
'Copyright 2007 Raymond Allen
'Modified Parallax's file to use 16x16 4-color tiles and display custom tiles

'You can change 2 lines in dat section (as indicated there) to get non-interlaced mode


CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000
  
    'number of custom 16x16 characters              
  nuchars = 80   '!!!!! you must have the correct # here for alignment later

  'for display
  cols = 64        'characters are 16 pixels wide
  rows = 48        '           and 32 pixels tall   (2 16-pixel rows per character)
  tiles = cols * rows


  display_base = $6000
  'screensize = cols * rows
  'lastrow = screensize - cols
  'tv_count = 14
  vga_params = 21 

  nCardsInDeck=52

  
VAR

  'variables for display
  long  col, row, color, flag
  long  array[tiles/2]                  

    'for custom characters
  word user_charbase

    'for drawing buttons
  word ptr
  byte boxcolor

  'for playing cards
  byte nDecks
  byte cards[nCardsInDeck-1]
  word nCardsLeft

OBJ

  vga :  "VGA_1024x768_Tile_Driver_With_Cursor"  
  'kb : "keyboard"
  'mouse : "mouse" 


PUB main|i,j,offx,offy
  '64 byte align the user characters
  user_charbase := @uchar & $FFC0 'destination
  'user_charbase_offset := user_charbase-@uchar  
  longmove(user_charbase,@uchar,16*nuchars)
    
  'start VGA
  startVGA

  'start mouse
  'mouse.start(24, 25)

  'start the keyboard
  'kb.start(26, 27)




  'start up cards
  nDecks:=1 
  InitShoe

  offx:=8
  offy:=5

        
  repeat
    out(0) 'clear screen

    'print some text  
    color:=3
    col:=0+offx
    row:=0+offy
    PrintStr(STRING("Player:"))
    col:=0+offx
    row:=10+offy
    PrintStr(STRING("Dealer:"))
    'color:=3
    'col:=3
    'row:=5
    'PrintStr(STRING("Click Deal or Hit Any Key"))
    boxcolor:=15
    box(14+offx,21+offy,10,2)'left,top,width,height
    color:=4
    col:=15+offx
    row:=22+offy
    PrintStr(String("   Deal   "))
    color:=0
    col:=0+offx
    row:=26+offy
    PrintStr(String("Bet: 23    Credits: 78"))

    repeat i from 0 to 1
      repeat j from 0 to 4
        'print blank cards slowly
        PaintBlankCard(7*j+3+offx,10*i+2+offy,@BlankCardEdges,11)
        waitcnt(cnt+clkfreq/4)
    waitcnt(cnt+clkfreq/2)
    repeat i from 0 to 1
      repeat j from 0 to 4
        'print random cards slowly
        PaintCard(7*j+3+offx,10*i+2+offy,DrawCard)
        waitcnt(cnt+clkfreq/4)
    waitcnt(cnt+clkfreq*3)    
       
PRI InitShoe|i
  'initialize shoe
  nCardsLeft:=nCardsInDeck*nDecks
  repeat i from 1 to nCardsInDeck
    cards[i-1]:=nDecks
    
PRI DrawCard:i
  'pick a card from shoe
  if (nCardsLeft=<0)
    InitShoe
  repeat
    i:=RND(nCardsInDeck)
  until cards[i]>0
  cards[i]--
  nCardsLeft--
    
PUB startVGA

  vga.start(16, @array, @vgacolors, 0,0,0)


PRI stopVGA

'' Stop terminal - frees a cog

  vga.stop


PUB box(left,top,width,height) | x, y, i

  ptr := top * cols + left
  boxchr($0)
  repeat i from 1 to width
    boxchr($C)
  boxchr($8)
  repeat i from 1 to height
    ptr := (top + i) * cols + left
    boxchr($A)
    ptr += width
    boxchr($B)
  ptr := (top + height + 1) * cols + left
  boxchr($1)
  repeat i from 1 to width
    boxchr($D)
  boxchr($9)

PRI boxchr(c): i

  array.word[ptr++] := $8000 + c << 6 + boxcolor' boxcolor << 10 + $200 + c


PRI RND(n):x|r2,r5            'x[i]=(192+179*x[i-1]) mod 577; x[1]=238
    'a basic LCG psuedo-random number generator
    'http://en.wikipedia.org/wiki/Linear_congruential_generator
    'generates a number 0..576 used to return number 0..n
    'n must be much less than 577
   x:=(192+179*RND1)//577
   RND1:=x
   x:=x*n/577
   

PRI PrintStr(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    out(byte[stringptr++])


PRI dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    out("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      out(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      out("0")
    i /= 10


PRI hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    out(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PRI bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    out((value <-= 1) & 1 + "0")


PRI out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $05 = USER 1-BIT CHARACTER
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case flag
    $00: case c
           $00: wordfill(@array, $8000 + $20 << 6, tiles)
                col := row := 0
           $01: col := row := 0
           $05: flag:=c
           $08: if col
                  col--
           $09: repeat
                  print(" ")
                while col & 7
           $0A..$0C: flag := c
                     return
           $0D: newline
           other: print(c)
    $0A: col := c // cols
    $0B: row := c // rows
    $0C: color := c & 7
    $05: uPrint(c,row,col++)
         if ++col == cols
           newline
  flag := 0



PRI print(c) |i,k
  k := color << 1 + c & 1
  i := $8000 + (c & $FE) << 6 + k
  array.word[row * cols + col] := i'(color << 1 + c & 1) << 10 + $200 + c & $FE
  array.word[(row+1) * cols + col] :=i|$40':= (color << 1 + c & 1) << 10 + $200 + c & $FE +1 
  if ++col == cols
    newline

PRI uPrint(c,ncol,nrow)
  uPrintTop(c,ncol,nrow)
  uPrintBottom(c,ncol,nrow+1)
  
PRI uPrintTop(c,ncol,nrow)|i,k
  'print top part of a character
  k := color << 1 + c & 1
  i := user_charbase + (c & $FE) << 6 + k
  array.word[nrow * cols + ncol] := i'user_charbase + (c<<6)  + color'(color << 1 + c & 1) << 10 + user_charbase>>6 + c & $FE

PRI uPrintBottom(c,ncol,nrow)|i,k
  'print bottom part of a character
    k := color << 1 + c & 1
  i := user_charbase + (c & $FE) << 6 + k
  array.word[nrow * cols + ncol] := i+$40'user_charbase + (c<<6)  + color+$40'(color << 1 + c & 1) << 10 + user_charbase>>6 + c & $FE +1 

PRI Bitmap2Bit(pBitmap, xPos, yPos, xSize, ySize, clr)|c,i,j,BmpAddress
  row:=yPos
  col:=xPos
  c:=0
  BmpAddress:=pBitmap+user_charbase-@uchar
  repeat j from 0 to (ySize-1)
    repeat i from 0 to (xSize-1)
      array.word[row * cols + col] := BmpAddress + (c<<6)  + clr
      'Print2Bit(c,clr,pBitmap)
      c++
      col++
    row++
    col:=xPos

PRI PaintCard(xPos,yPos,card)|rank,suit,i,j       'card is 0..51
  PaintBlankCard(xPos,yPos,@CardEdges,12)
  'dissect card number to get suit, rank
  suit:=card/13    '0=diamond, 1=heart, 2=club, 3=spade
  rank:=card//13   '0=ace, 1=2 ... 9=10, 10=Jack, 11=Queen, 12=King
  'pick color
  color:=1+suit/2  '2=red on white, 3=black on white
  'draw rank
  uPrintTop(12+rank,xPos+1,yPos+1)
  uPrintBottom(12+rank,xPos+5,yPos+6)
  'draw small suit
  uPrintTop(4+suit,xPos+1,yPos+2)
  uPrintBottom(4+suit,xPos+5,yPos+5)
  'draw at center top&bottom
  case rank
    1,2:  '2,9
      uPrintTop(suit,xPos+3,yPos+2)
      uPrintBottom(suit,xPos+3,yPos+5)
  'draw at left&right, top&bottom
  case rank
    3,4,5,6,7,8,9:  '4,5,6,9,10
      uPrintTop(suit,xPos+2,yPos+2)
      uPrintBottom(suit,xPos+2,yPos+5)
      uPrintTop(suit,xPos+4,yPos+2)
      uPrintBottom(suit,xPos+4,yPos+5)  
  'draw single at middle center 
  case rank
    0,2,4,8:  'Ace, 3,5,9
      uPrint(suit+8,xPos+3,yPos+3)
  'draw single at top center 
  case rank
    6,7,9:  '7,8,10
      uPrint(suit+8,xPos+3,yPos+2)
  'draw single at bottom center 
  case rank
    7,9:  '8,10
      uPrint(suit+8,xPos+3,yPos+4)      
  'draw single center left&right
  case rank
    5,6,7:  '6,7
      uPrint(suit+8,xPos+2,yPos+3)
      uPrint(suit+8,xPos+4,yPos+3)
  'draw both left&right center
  case rank
    8,9:      '9,10
      uprint(suit,xPos+2,yPos+3)
      uPrint(suit,xPos+4,yPos+3)
  'draw face cards faces
  case rank
    10:  'Jack
      Bitmap2Bit(@Jack, xPos+2, yPos+2, 3, 4, 12+color)
    11:  'Queen
      Bitmap2Bit(@Queen, xPos+2, yPos+2, 3, 4, 12+color)
    12:  'King
      Bitmap2Bit(@King, xPos+2, yPos+2, 3, 4, 12+color)
          
  'draw face cards suits
  case rank
    10,11:  'Jack, Queen
      uPrintBottom(suit,xPos+2,yPos+5)
      uPrintTop(suit,xPos+4,yPos+2)
    12: 'King
      uPrintTop(suit,xPos+2,yPos+2)
      uPrintBottom(suit,xPos+4,yPos+5)      
      
         
  
     



PRI PaintBlankCard(xPos,yPos,pCard,clr)|i,j,BmpAddress,c     
  c:=0
  row:=yPos
  col:=xPos
  BmpAddress:=pCard+user_charbase-@uchar
  'draw top edge
  array.word[row * cols + col++] := BmpAddress + ((c++)<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c++
  repeat i from 1 to 5
    array.word[row * cols + col++] := BmpAddress + (c<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c
  array.word[row * cols + col] := BmpAddress + ((++c)<<6)  + clr'(clr) << 10 + BmpAddress>>6 + (++c)
  'draw middle
  c++
  repeat i from 1 to 6
    col:=xPos 
    row++
    array.word[row * cols + col++] := BmpAddress + (c<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c
    repeat j from 1 to 5
      array.word[row * cols + col++] := BmpAddress + ((c+1)<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c+1
    array.word[row * cols + col] := BmpAddress + ((c+2)<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c+2   
  'draw bottom
  col:=xPos
  row++
  c+=3
  array.word[row * cols + col++] := BmpAddress + ((c++)<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c++
  repeat i from 1 to 5
    array.word[row * cols + col++] := BmpAddress + (c<<6)  + clr'(clr) << 10 + BmpAddress>>6 + c
  array.word[row * cols + col] := BmpAddress + ((++c)<<6)  + clr'(clr) << 10 + BmpAddress>>6 + (++c)


    
PRI newline | i

  col := 0
  if (row += 2) == rows
    row -= 2
    'scroll lines
    repeat i from 0 to rows-3
      wordmove(@array.word[i*cols], @array.word[(i+2)*cols], cols)
    'clear new line
    wordfill(@array.word[(rows-2)*cols], $8000 + $20 << 6, cols<<1)


DAT
 vgacolors long

'0..1:  text color 0:  
  long $00100010       'black on green       
  long $00001010
'2..3:  text color 1: 
  long $C0FCC0FC       ' red on white   
  long $C0C0FCFC
'4..5:  text color 2:        
  long $00FC00FC       'black on white  
  long $0000FCFC 
'6..7:  text color 3:     
  long $F010F010        '3: Yellow on Green  
  long $F0F01010 
'8..9:  text color 4:    
  long $00A800A8      '4: black on grey  
  long $0000A8A8 
'10:  graphics 0:  
  long $FC54A8A8         'gray  
'11:  graphics 1:  'blank card edge color   
  long $FC00C010         'white,black,red,green 
'12:  graphics 2:  'card edge colors
  long $100000FC         ''green,black,black,white  
'13:  graphics 3:  'red face card colors 
  long $F0C000FC          '  yellow,red,black,white
'14:  graphics 4:   'black face card colors 
  long $F000C0FC         ''yellow,black,red,white   
'15:  graphics 5:  button colors
  long $FC54A8A8         'lt grey, dk.gray, gray, gray 


RND1 word 238    'random number generator seed

padding LONG  7[16] 'alignment padding for the following user defined characters     

uchar long
'0,1: diamond, heart
        LONG %00001010_10100001_00101010_10000000
        LONG %00101010_10101101_11101010_10100000
        LONG %10101010_10111101_11111010_10101000
        LONG %10101010_11111111_11111110_10101000
        LONG %10101011_11111111_11111111_10101000
        LONG %10101011_11111111_11111111_10101000
        LONG %10101111_11111111_11111111_11101000
        LONG %00111111_11111111_11111111_11110000
        LONG %00101111_11111111_11111111_11100000
        LONG %00001011_11111111_11111111_10000000
        LONG %00000011_11111111_11111111_00000000
        LONG %00000000_11111111_11111100_00000000
        LONG %00000000_00111111_11110000_00000000
        LONG %00000000_00001111_11000000_00000000
        LONG %00000000_00000011_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000011_00000000_00000000
        LONG %00000000_00001111_11000000_00000000
        LONG %00000000_00111111_11110000_00000000
        LONG %00000000_11111111_11111100_00000000
        LONG %00000011_11111111_11111111_00000000
        LONG %00001011_11111111_11111111_10000000
        LONG %00101111_11111111_11111111_11100000
        LONG %00111111_11111111_11111111_11110000
        LONG %10101111_11111111_11111111_11101000
        LONG %10101011_11111111_11111111_10101000
        LONG %10101011_11111111_11111111_10101000
        LONG %10101010_11111111_11111110_10101000
        LONG %10101010_10111101_11111010_10101000
        LONG %00101010_10101101_11101010_10100000
        LONG %00001010_10100001_00101010_10000000
'2,3:  club, spade
        LONG %00000000_00000111_01000000_00000000
        LONG %00000000_00011111_11010000_00000000
        LONG %00000000_01111111_11110100_00000000
        LONG %00000000_11111111_11111100_00000000
        LONG %00000010_11111111_11111110_00000000
        LONG %00001010_10111111_11111010_10000000
        LONG %00101111_11111111_11111111_11100000
        LONG %00111111_11111111_11111111_11110000
        LONG %11111111_11111111_11111111_11111100
        LONG %11111111_11111111_11111111_11111100
        LONG %11111111_11111111_11111111_11111100
        LONG %10111111_11110011_00111111_11111000
        LONG %00101111_11000011_00001111_11100000
        LONG %00000000_00001111_11000000_00000000
        LONG %00000000_00111111_11110000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00111111_11110000_00000000
        LONG %00000000_00001111_11000000_00000000
        LONG %00101111_11000011_00001111_11100000
        LONG %10111111_11110011_00111111_11111000
        LONG %11111111_11111111_11111111_11111100
        LONG %11111111_11111111_11111111_11111100
        LONG %11111111_11111111_11111111_11111100
        LONG %00111111_11111111_11111111_11110000
        LONG %00101111_11111111_11111111_11100000
        LONG %00001010_10111111_11111010_10000000
        LONG %00000010_11111111_11111110_00000000
        LONG %00000000_11111111_11111100_00000000
        LONG %00000000_01111111_11110100_00000000
        LONG %00000000_00011111_11010000_00000000
        LONG %00000000_00000111_01000000_00000000
 '4,5:  small diamond, heart
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00101010_01101010_00000000
        LONG %00000000_10101011_01111010_10000000
        LONG %00000000_10101111_11111110_10000000
        LONG %00000000_10111111_11111111_10000000
        LONG %00000000_10111111_11111111_10000000
        LONG %00000000_00111111_11111111_00000000
        LONG %00000000_00001111_11111100_00000000
        LONG %00000000_00000011_11110000_00000000
        LONG %00000000_00000000_11000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_11000000_00000000
        LONG %00000000_00000011_11110000_00000000
        LONG %00000000_00001111_11111100_00000000
        LONG %00000000_00111111_11111111_00000000
        LONG %00000000_10111111_11111111_10000000
        LONG %00000000_10111111_11111111_10000000
        LONG %00000000_10101111_11111110_10000000
        LONG %00000000_10101011_01111010_10000000
        LONG %00000000_00101010_01101010_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
'6,7:  small club, spade
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000001_01010000_00000000
        LONG %00000000_00000101_11010100_00000000
        LONG %00000000_00000111_11110100_00000000
        LONG %00000000_00001111_11111100_00000000
        LONG %00000000_01111011_11111011_01000000
        LONG %00000001_11111111_11111111_11010000
        LONG %00000001_11111111_11111111_11010000
        LONG %00000001_11111111_11111111_11010000
        LONG %00000000_01111100_11001111_01000000
        LONG %00000000_00000011_11110000_00000000
        LONG %00000000_00000011_11110000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000011_11110000_00000000
        LONG %00000000_00000011_11110000_00000000
        LONG %00000000_01111100_11001111_01000000
        LONG %00000001_11111111_11111111_11010000
        LONG %00000001_11111111_11111111_11010000
        LONG %00000001_11111111_11111111_11010000
        LONG %00000000_01111011_11111011_01000000
        LONG %00000000_00001111_11111100_00000000
        LONG %00000000_00000111_11110100_00000000
        LONG %00000000_00000101_11010100_00000000
        LONG %00000000_00000001_01010000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
'8,9: 1diamond, 1heart
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00001010_10100001_00101010_10000000
        LONG %00101010_10101101_11101010_10100000
        LONG %10101010_10111101_11111010_10101000
        LONG %10101010_11111111_11111110_10101000
        LONG %10101011_11111111_11111111_10101000
        LONG %10101011_11111111_11111111_10101000
        LONG %10101111_11111111_11111111_11101000
        LONG %00111111_11111111_11111111_11110000
        LONG %00101111_11111111_11111111_11100000
        LONG %00001011_11111111_11111111_10000000
        LONG %00000011_11111111_11111111_00000000
        LONG %00000000_11111111_11111100_00000000
        LONG %00000000_00111111_11110000_00000000
        LONG %00000000_00001111_11000000_00000000
        LONG %00000000_00000011_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
'10,11: 1club, 1spade
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000101_01000000_00000000
        LONG %00000000_00010111_01010000_00000000
        LONG %00000000_01011111_11010100_00000000
        LONG %00000000_01111111_11110100_00000000
        LONG %00000000_11111111_11111100_00000000
        LONG %00000010_10111111_11111010_00000000
        LONG %00001111_11111111_11111111_11000000
        LONG %00111111_11111111_11111111_11110000
        LONG %01111111_11111111_11111111_11110100
        LONG %11111111_11111111_11111111_11111100
        LONG %11111111_11111111_11111111_11111100
        LONG %10111111_11111011_10111111_11111000
        LONG %10101111_11100011_00101111_11101000
        LONG %00101010_10000111_01001010_10100000
        LONG %00000000_00011111_11010000_00000000
        LONG %00000000_00101010_10100000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000
        LONG %00000000_00000000_00000000_00000000

'12,13:  Ace, 2
        LONG %00000000_00101010_11101000_00000000
        LONG %00000000_10101010_11101010_10000000
        LONG %00000000_10100000_01001010_10000000
        LONG %00000000_10100101_01011010_10000000
        LONG %00000000_10100101_01010000_00000000
        LONG %00000000_10111111_00010100_00000000
        LONG %00000000_00111111_10010100_00000000
        LONG %00000000_00111111_10010100_00000000
        LONG %00000000_01011010_10100101_01000000
        LONG %00000000_01010101_11111101_01000000
        LONG %00000000_11110101_01111111_11000000
        LONG %00000101_11110101_01011111_11010000
        LONG %00000101_11100000_00001011_11010000
        LONG %00010101_11111010_10101111_11010100
        LONG %00010101_11111010_10101111_11010100
        LONG %00010101_01010000_00000101_01010100
        LONG %00010101_01010000_00000101_01010100
        LONG %00010111_11111010_10101111_01010100
        LONG %00010111_11111010_10101111_01010100
        LONG %00000111_11100000_00001011_01010000
        LONG %00000111_11110101_01011111_01010000
        LONG %00000011_11111101_01011111_00000000
        LONG %00000001_01111111_01010101_00000000
        LONG %00000001_01011010_10100101_00000000
        LONG %00000000_00010110_11111100_00000000
        LONG %00000000_00010110_11111100_00000000
        LONG %00000000_00010100_11111110_00000000
        LONG %00000000_00000101_01011010_00000000
        LONG %00000010_10100101_01011010_00000000
        LONG %00000010_10100001_00001010_00000000
        LONG %00000010_10101011_10101010_00000000
        LONG %00000000_00101011_10101000_00000000



'34
        LONG %00000001_01010101_01010101_00000000
        LONG %00000001_01111111_01010101_00000000
        LONG %00000000_01111110_10000101_00000000
        LONG %00000000_00101111_10100000_00000000
        LONG %00000000_00101111_10100000_00000000
        LONG %00000000_00101011_11111000_00000000
        LONG %00000000_01111111_01111110_10000000
        LONG %00000001_01111111_01011110_10100000
        LONG %00001011_11111111_11111110_10100000
        LONG %00001011_11111010_10101010_10100000
        LONG %00001011_11111010_10101010_10100000
        LONG %00000001_01111010_00000101_00000000
        LONG %00000001_01111010_00000101_00000000
        LONG %00000001_01111111_01010101_00000000
        LONG %00000000_11111111_11010100_00000000
        LONG %00000000_10101010_10000000_00000000
        LONG %00000000_00000010_10101010_00000000
        LONG %00000000_00010111_11111111_00000000
        LONG %00000000_01010101_11111101_01000000
        LONG %00000000_01010000_10101101_01000000
        LONG %00000000_01010000_10101101_01000000
        LONG %00001010_10101010_10101111_11100000
        LONG %00001010_10101010_10101111_11100000
        LONG %00001010_10111111_11111111_11100000
        LONG %00001010_10110101_11111101_01000000
        LONG %00000010_10111101_11111101_00000000
        LONG %00000000_00101111_11101000_00000000
        LONG %00000000_00001010_11111000_00000000
        LONG %00000000_00001010_11111000_00000000
        LONG %00000000_01010010_10111101_00000000
        LONG %00000000_01010101_11111101_01000000
        LONG %00000000_01010101_01010101_01000000

'56
        LONG %00000001_01111111_11110101_00000000
        LONG %00000001_01111111_11110101_00000000
        LONG %00000001_01111111_11111101_00000000
        LONG %00000000_00000000_10111111_00000000
        LONG %00000000_00000000_00011111_00000000
        LONG %00000000_00101010_10111111_00000000
        LONG %00000000_01111111_11111111_00000000
        LONG %00000011_11111111_11111111_00000000
        LONG %00000011_11100000_00001010_00000000
        LONG %00000011_11100000_00001010_00000000
        LONG %00000011_11100000_00001010_00000000
        LONG %00000011_11100000_00011111_00000000
        LONG %00000011_11100000_00011111_00000000
        LONG %00000011_11111111_11111111_00000000
        LONG %00000011_11111111_11111111_00000000
        LONG %00000000_01111111_11111100_00000000
        LONG %00000000_00111111_11111101_00000000
        LONG %00000000_11111111_11111111_11000000
        LONG %00000000_11111111_11111111_11000000
        LONG %00000000_11110100_00001011_11000000
        LONG %00000000_11110100_00001011_11000000
        LONG %00000000_10100000_00001011_11000000
        LONG %00000000_10100000_00001011_11000000
        LONG %00000000_10100000_00001011_11000000
        LONG %00000000_11111111_11111111_11000000
        LONG %00000000_11111111_11111101_00000000
        LONG %00000000_11111110_10101000_00000000
        LONG %00000000_11110100_00000000_00000000
        LONG %00000000_11111110_00000000_00000000
        LONG %00000000_01111111_11111101_01000000
        LONG %00000000_01011111_11111101_01000000
        LONG %00000000_01011111_11111101_01000000

'78
        LONG %00000001_01111111_11111101_00000000
        LONG %00000001_01111111_11111101_00000000
        LONG %00000001_11111010_10101111_00000000
        LONG %00000000_11110100_00001010_00000000
        LONG %00000000_11110100_00001010_00000000
        LONG %00000000_11110100_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_00101111_10101000_00000000
        LONG %00000000_10101111_10101010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100001_01011010_00000000
        LONG %00000000_10100001_01011010_00000000
        LONG %00000000_10100001_01011010_00000000
        LONG %00000000_10101011_11111010_00000000
        LONG %00000000_10101011_11111010_00000000
        LONG %00000000_00101010_10101000_00000000
        LONG %00000000_00101010_10101000_00000000
        LONG %00000000_10101111_11101010_00000000
        LONG %00000000_10101111_11101010_00000000
        LONG %00000000_10100101_01001010_00000000
        LONG %00000000_10100101_01001010_00000000
        LONG %00000000_10100101_01001010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10101010_11111010_00000000
        LONG %00000000_00101010_11111000_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_00011111_00000000
        LONG %00000000_10100000_00011111_00000000
        LONG %00000000_10100000_00011111_00000000
        LONG %00000000_11111010_10101111_01000000
        LONG %00000000_01111111_11111101_01000000
        LONG %00000000_01111111_11111101_01000000

'9T
        LONG %00000000_11111111_11010110_10100000
        LONG %00001010_11111111_11110110_10100000
        LONG %00001011_11111111_11110111_10100000
        LONG %00001011_11000000_10110111_10100000
        LONG %00001011_11000000_10110111_10100000
        LONG %00001011_11000000_10110111_10100000
        LONG %00001011_11000000_10110111_10100000
        LONG %00001011_11000000_10110111_10100000
        LONG %00001011_11010101_11110111_10100000
        LONG %00001011_11010101_11110110_10100000
        LONG %00001011_11010101_11110110_10100000
        LONG %00001011_11000000_10100010_10100000
        LONG %00001011_11010100_10100010_10100000
        LONG %00001010_11111111_11110110_10100000
        LONG %00000000_11111111_11010110_10100000
        LONG %00000000_10111111_11010110_10100000
        LONG %00001010_10010111_11111110_00000000
        LONG %00001010_10010111_11111111_00000000
        LONG %00001010_10011111_11111111_10100000
        LONG %00001010_10001010_00010111_11100000
        LONG %00001010_10001010_00000011_11100000
        LONG %00001010_10011111_01010111_11100000
        LONG %00001010_10011111_01010111_11100000
        LONG %00001010_11011111_01010111_11100000
        LONG %00001010_11011110_00000011_11100000
        LONG %00001010_11011110_00000011_11100000
        LONG %00001010_11011110_00000011_11100000
        LONG %00001010_11011110_00000011_11100000
        LONG %00001010_11011110_00000011_11100000
        LONG %00001010_11011111_11111111_11100000
        LONG %00001010_10011111_11111111_10100000
        LONG %00001010_10010111_11111111_00000000

'JQ
        LONG %00000000_01111111_11111000_00000000
        LONG %00000000_11111111_11111010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001010_00000000
        LONG %00000000_10100101_00001011_01000000
        LONG %00000000_10100101_00001011_01000000
        LONG %00000000_10101111_10101011_01000000
        LONG %00000000_00101111_11111101_01000000
        LONG %00000010_10101001_01010101_00000000
        LONG %00000010_10100000_00000000_00000000
        LONG %00000000_00000000_00001010_10000000
        LONG %00000000_01010101_01101010_10000000
        LONG %00000001_01111111_11111000_00000000
        LONG %00000001_11101010_11111010_00000000
        LONG %00000001_11100000_01011010_00000000
        LONG %00000001_11100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10100000_01011010_00000000
        LONG %00000000_10101111_11111111_00000000
        LONG %00000000_00101111_11111101_00000000

'K
        LONG %00001111_11111111_00111111_11110000
        LONG %00001111_11111111_00111111_11110000
        LONG %00001111_11111111_00111111_11110000
        LONG %00000000_00111111_00001111_11000000
        LONG %00000000_00001111_11001111_11000000
        LONG %00000000_00001111_11001111_11000000
        LONG %00000000_00000000_11111111_11000000
        LONG %00000000_00000000_00111111_11000000
        LONG %00000000_00000000_11111111_11000000
        LONG %00000000_00000000_11111111_11000000
        LONG %00000000_00001111_11001111_11000000
        LONG %00000000_00111111_00001111_11000000
        LONG %00000000_11110000_00001111_11000000
        LONG %00001111_11111111_00111111_11110000
        LONG %00001111_11111111_00111111_11110000
        LONG %00001111_11111111_00111111_11110000
        LONG %00001111_11111100_11111111_11110000
        LONG %00001111_11111100_11111111_11110000
        LONG %00001111_11111100_11111111_11110000
        LONG %00000011_11110000_00001111_00000000
        LONG %00000011_11110000_11111100_00000000
        LONG %00000011_11110011_11110000_00000000
        LONG %00000011_11111111_00000000_00000000
        LONG %00000011_11111111_00000000_00000000
        LONG %00000011_11111100_00000000_00000000
        LONG %00000011_11111111_00000000_00000000
        LONG %00000011_11110011_11110000_00000000
        LONG %00000011_11110011_11110000_00000000
        LONG %00000011_11110000_11111100_00000000
        LONG %00001111_11111100_11111111_11110000
        LONG %00001111_11111100_11111111_11110000
        LONG %00001111_11111100_11111111_11110000



CardEdges long
        file "edges.dat"  '3x3=9
BlankCardEdges long
        file "edgesblank.dat"  '3x3=9        
King long
        file "king.dat"  '3x4=12
Queen long
        file "queen.dat"  '3x4=12
Jack long
        file "jack.dat"   '3x4=12        